// assets/js/db/logind.js

// ✅ Use the already initialized Supabase client
const supabase = window.supabase;

// ✅ Sign In Function
async function signIn() {
  const email = document.getElementById("email").value.trim();
  const password = document.getElementById("password").value.trim();

  if (!email || !password) {
    alert("⚠️ Please enter both email and password.");
    return;
  }

  const { data, error } = await supabase.auth.signInWithPassword({
    email,
    password,
  });

  if (error) {
    if (error.message.includes("Invalid login credentials")) {
      alert("❌ Incorrect email or password.");
    } else if (error.message.includes("Email not confirmed")) {
      alert(
        "⚠️ Please check your email and confirm your account before logging in."
      );
    } else {
      alert("❌ " + error.message);
    }
    return;
  }

  // ✅ Get the staff name from user metadata and store it
  const staffName = data.user.user_metadata.staff_name;
  if (staffName) {
    localStorage.setItem("staffName", staffName);
  }

  // ✅ Redirect to drive.html after login
  window.location.href = "/pages/drive/drive.html";
}

// Attach to button
document.addEventListener("DOMContentLoaded", () => {
  const btn = document.querySelector(".btn-signin");
  if (btn) {
    btn.addEventListener("click", signIn);
  }
});
