const supabase = window.supabase;

document
  .getElementById("signup-form")
  .addEventListener("submit", async (event) => {
    event.preventDefault();

    const email = document.getElementById("email").value.trim();
    const password = document.getElementById("password").value.trim();

    if (!email || !password) {
      alert("Please enter both email and password");
      return;
    }

    const { data, error } = await supabase.auth.signUp({ email, password });

    if (error) {
      alert("Signup error: " + error.message);
    } else {
      alert(
        "Signup successful! Please check your email to verify your account."
      );
      // Optional: redirect to login page after signup
      window.location.href = "login.html";
    }
  });
