const SUPABASE_URL = "https://bmroymhdqqbzlubpfjvs.supabase.co";
const SUPABASE_ANON_KEY =
  "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJzdXBhYmFzZSIsInJlZiI6ImJtcm95bWhkcXFiemx1YnBmanZzIiwicm9sZSI6ImFub24iLCJpYXQiOjE3NDU0NTc4MjMsImV4cCI6MjA2MTAzMzgyM30.k-Vcbza0LeYr9mtQXwD2gHkIys-kmU0uky6VJ0LMX3g";
const supabase =
  supabase || window.supabase || createClient(SUPABASE_URL, SUPABASE_ANON_KEY);

// List of base64 fields to migrate
const base64Fields = [
  "profile_image_url",
  "profile_photo",
  "english_result_file",
  "Passport_FPage",
  "Healthdeclare_file",
  "payment_receipt_file",
  "declaration_signature",
  "Cert_sec_stud",
  "Certificate_completion_studies_file",
  "second_payment",
  "chsi",
  "cscse",
  "pre_chsi",
  "pre_cscse",
  "passport_base64",
  "offer_letter_base64",
  "emgs_base64",
];

// Helper: Convert base64 string to Blob
function base64ToBlob(base64Data) {
  const parts = base64Data.split(",");
  const mime = parts[0].match(/:(.*?);/)[1];
  const byteString = atob(parts[1]);
  const ab = new ArrayBuffer(byteString.length);
  const ia = new Uint8Array(ab);
  for (let i = 0; i < byteString.length; i++) ia[i] = byteString.charCodeAt(i);
  return new Blob([ab], { type: mime });
}

async function migrateBase64ToStorage() {
  if (localStorage.getItem("migrationDone")) {
    console.log("Migration already completed.");
    return;
  }

  console.log("Starting migration...");

  const { data: students, error } = await supabase
    .from("student_applications")
    .select("*");

  if (error) {
    console.error("Error fetching student data:", error);
    return;
  }

  for (const student of students) {
    const studentId = student.id;

    for (const field of base64Fields) {
      const base64 = student[field];

      if (base64 && base64.startsWith("data:")) {
        try {
          const blob = base64ToBlob(base64);
          const fileExt = blob.type.split("/")[1].split(";")[0];
          const filename = `${studentId}/${field}.${fileExt}`;

          const { error: uploadError } = await supabase.storage
            .from("application-drive")
            .upload(filename, blob, { upsert: true });

          if (uploadError) {
            console.error(`Upload error for ${filename}:`, uploadError);
            continue;
          }

          const {
            data: { publicUrl },
          } = supabase.storage.from("application-drive").getPublicUrl(filename);

          await supabase
            .from("student_applications")
            .update({ [field]: publicUrl })
            .eq("id", studentId);

          console.log(`✅ Migrated ${field} for student ${studentId}`);
        } catch (err) {
          console.error(
            `Error processing ${field} for student ${studentId}:`,
            err
          );
        }

        // Wait 500ms to avoid API rate limit
        await new Promise((resolve) => setTimeout(resolve, 500));
      }
    }
  }

  localStorage.setItem("migrationDone", "true");
  console.log("✅ Migration completed!");
}

migrateBase64ToStorage();
