import { createClient } from "@supabase/supabase-js";

const SUPABASE_URL = "https://YOUR_PROJECT.supabase.co"; // Ganti ikut projek awak
const SUPABASE_SERVICE_ROLE_KEY = "YOUR_SERVICE_ROLE_KEY"; // Ganti dengan service_role key

const supabase = createClient(SUPABASE_URL, SUPABASE_SERVICE_ROLE_KEY);

async function organizeFiles() {
  const { data: applications, error } = await supabase
    .from("student_applications")
    .select("*");

  if (error) {
    console.error("Error fetching student_applications:", error);
    return;
  }

  const fileColumns = [
    "profile_photo",
    "ResultQualification",
    "english_result_file",
    "Passport_FPage",
    "Healthdeclare_file",
    "payment_receipt_file",
    "declaration_signature",
    "graduatesecondry",
    "Cert_sec_stud",
    "Certificate_completion_studies_file",
    "second_payment",
    "chsi",
    "cscse",
    "pre_chsi",
    "pre_cscse",
  ];

  for (const app of applications) {
    for (const col of fileColumns) {
      const oldPath = app[col];

      if (oldPath && oldPath.includes("/")) {
        const fileName = oldPath.split("/").pop();
        const newPath = `${col}/${fileName}`;

        // Copy file ke folder baru dalam bucket
        const { error: copyError } = await supabase.storage
          .from("application-drive")
          .copy(oldPath, newPath);

        if (copyError) {
          console.error(`❌ Failed to copy ${oldPath} → ${newPath}`, copyError);
        } else {
          console.log(`✅ Successfully moved ${oldPath} → ${newPath}`);
        }
      }
    }
  }
}

organizeFiles()
  .then(() => console.log("Finish organizing files in bucket!"))
  .catch((e) => console.error("Error:", e));
